@echo off
rem Copyright M.Mohai 1999-2017
setlocal enableextensions

echo:
echo Clean XPS MultiQuant folder
echo _________________________________________________________________________
echo:
echo This command file will delete files and folders of XPS MultiQuant.
echo Use it after uninstall, if some files could not be deleted.
echo To remove registry data, merge the "DeleteXMQregistry.reg" file.
echo:

rem Default folder of XPS MultiQuant 
set xmqdir=XMQ

ver | find "10.0" > nul
if not errorlevel 1 goto NT
ver | find "6.3" > nul
if not errorlevel 1 goto NT
ver | find "6.2" > nul
if not errorlevel 1 goto NT
ver | find "6.1" > nul
if not errorlevel 1 goto NT
ver | find "6.0" > nul
if not errorlevel 1 goto NT
ver | find "5.2" > nul
if not errorlevel 1 goto NT
ver | find "XP" > nul
if not errorlevel 1 goto NT
ver | find "2000" > nul
if not errorlevel 1 goto NT
ver | find "NT" > nul
if not errorlevel 1 goto NT
ver | find "95" > nul
if not errorlevel 1 goto 9X
ver | find "98" > nul
if not errorlevel 1 goto 9X
ver | find "Millennium" > nul
if not errorlevel 1 goto 9X
echo Windows version could not be determined
goto NO

:NT
set progdir=%ProgramFiles%
if exist "%ProgramFiles(x86)%" set progdir=%ProgramFiles(x86)%
title Deleting XPS MultiQuant
set /p answ=Do you want to continue [Y,N]? 
if /i '%answ%'=='Y' goto ERA
goto NO

:9X
set progdir=C:\Program Files
choice /c:YN Do you want to continue 
if errorlevel 2 goto NO

:ERA
if not exist "%progdir%\%xmqdir%" goto DIR
pushd %progdir%\%xmqdir%
if exist "XMQ.exe" (
  echo:
  echo XPS MultiQuant not uninstalled
  goto NO
)
cd Samples
dir
echo:
echo:
echo Deleting files from Samples and Import
pause
attrib -r *.*
del /q *.*
cd ..
rmdir Samples
if exist "Import" (
  cd Import
  del /q *.*
  cd ..
  rmdir Import
)
echo:
echo:
echo:
dir
echo:
echo:
echo Deleting files from XMQ
pause
del /q *.*
echo:
echo:
echo:
cd ..
dir /a:d %xmqdir%*
echo:
echo:
echo Deleting XMQ folder
pause
rmdir %xmqdir%
echo:
echo Deleting finished
goto END

:DIR
echo Default location of XPS MultiQuant is not found

:NO
echo Batch terminated

:END
echo:
popd
pause
