@echo off
rem Copyright M.Mohai 1999 - 2023

echo:
echo XPS MultiQuant update from versions 7.00 - 7.82 to 7.83
echo ___________________________________________________________________
echo:
echo This command file will copy the new files to 
echo the default location of XPS MultiQuant. 
echo:

rem Default folder of XPS MultiQuant 
set xmqdir=XMQ

ver | find "10.0" > nul
if not errorlevel 1 goto NT
ver | find "6.3" > nul
if not errorlevel 1 goto NT
ver | find "6.2" > nul
if not errorlevel 1 goto NT
ver | find "6.1" > nul
if not errorlevel 1 goto NT
ver | find "6.0" > nul
if not errorlevel 1 goto NT
ver | find "5.2" > nul
if not errorlevel 1 goto NT
ver | find "XP" > nul
if not errorlevel 1 goto NT
ver | find "2000" > nul
if not errorlevel 1 goto NT
ver | find "NT" > nul
if not errorlevel 1 goto NT
ver | find "95" > nul
if not errorlevel 1 goto 9X
ver | find "98" > nul
if not errorlevel 1 goto 9X
ver | find "Millennium" > nul
if not errorlevel 1 goto 9X
echo Windows version could not be determined
goto MAN

:NT
set progdir=%ProgramFiles%
if exist "%ProgramFiles(x86)%" set progdir=%ProgramFiles(x86)%
title XPS MultiQuant upgrade
set /p answ=Do you want to continue [Y,N]? 
if /i '%answ%'=='Y' goto CPY
goto NO

:9X
echo:
echo This is an old Windows version; use the Update98.bat command file.
goto NO

:CPY
if not exist "%progdir%\%xmqdir%\XMQ.exe"  goto DIR
pushd %~dp0
echo:
echo Files are copied to %progdir%\%xmqdir%
copy /y /b XMQ.exe "%progdir%\%xmqdir%"
copy /y /b XMQ.chm "%progdir%\%xmqdir%"
copy /y /b XMQ.lib "%progdir%\%xmqdir%"
copy /y /b XMQ-Manual.pdf "%progdir%\%xmqdir%"
copy /y /a ReadMeUpd.txt "%progdir%\%xmqdir%"
echo:
echo Files are copied to %progdir%\%xmqdir%\Samples
attrib -r "%progdir%\%xmqdir%\Samples\*.*"
copy /y /b *.mqd "%progdir%\%xmqdir%\Samples"
copy /y /b *.mqt "%progdir%\%xmqdir%\Samples"
copy /y /a *.mqx "%progdir%\%xmqdir%\Samples"
copy /y /a *.mtr "%progdir%\%xmqdir%\Samples"
copy /y /b *.doc "%progdir%\%xmqdir%\Samples"
copy /y /b *.xls "%progdir%\%xmqdir%\Samples"
if exist "%progdir%\%xmqdir%\Samples\SteelDocument.doc"  del /q "%progdir%\%xmqdir%\Samples\SteelDocument.doc"
if exist "%progdir%\%xmqdir%\Samples\Steel.mqd"  del /q "%progdir%\%xmqdir%\Samples\Steel.mqd"
if exist "%progdir%\%xmqdir%\Default.mtr"  del /q "%progdir%\%xmqdir%\Default.mtr"
attrib +r "%progdir%\%xmqdir%\Samples\*.*"
echo:
echo Update finished
popd
goto END

:DIR
echo Default location of XPS MultiQuant is not found.

:MAN
echo Copy files manually.

:NO
echo Batch terminated

:END
echo:
pause
