@echo off
rem Copyright M.Mohai 1999 - 2023

echo:
echo XPS MultiQuant update from versions 7.00 - 7.82 to 7.83
echo ___________________________________________________________________
echo.
echo This command file will copy the new files to the default location
echo of XPS MultiQuant on Windows 98 and Millenium systems. 
echo.

rem Default folder of XPS MultiQuant 
set xmqdir=XMQ

ver | find "95" > nul
if not errorlevel 1 goto 9X
ver | find "98" > nul
if not errorlevel 1 goto 9X
ver | find "Millennium" > nul
if not errorlevel 1 goto 9X
echo.
echo This is a newer Windows version; use the Update.cmd command file.
goto NO

:9X
set progdir=C:\Program Files
choice /c:YN Do you want to continue 
if errorlevel 2 goto NO

if not exist "%progdir%\%xmqdir%\XMQ.exe"  goto DIR
echo.
echo Files are copied to %progdir%\%xmqdir%
copy /y /b XMQ.exe "%progdir%\%xmqdir%"
copy /y /b XMQ.chm "%progdir%\%xmqdir%"
copy /y /b XMQ.lib "%progdir%\%xmqdir%"
copy /y /b XMQ-Manual.pdf "%progdir%\%xmqdir%"
copy /y /a ReadMeUpd.txt "%progdir%\%xmqdir%"
echo.
echo Files are copied to %progdir%\%xmqdir%\Samples
attrib -r "%progdir%\%xmqdir%\Samples\*.*"
copy /y /b *.mqd "%progdir%\%xmqdir%\Samples"
copy /y /b *.mqt "%progdir%\%xmqdir%\Samples"
copy /y /a *.mqx "%progdir%\%xmqdir%\Samples"
copy /y /a *.mtr "%progdir%\%xmqdir%\Samples"
copy /y /b *.doc "%progdir%\%xmqdir%\Samples"
copy /y /b *.xls "%progdir%\%xmqdir%\Samples"
if exist "%progdir%\%xmqdir%\Samples\SteelDocument.doc"  del "%progdir%\%xmqdir%\Samples\SteelDocument.doc"
if exist "%progdir%\%xmqdir%\Samples\Steel.mqd"  del "%progdir%\%xmqdir%\Samples\Steel.mqd"
if exist "%progdir%\%xmqdir%\Default.mtr"  del "%progdir%\%xmqdir%\Default.mtr"
attrib +r "%progdir%\%xmqdir%\Samples\*.*"
echo.
echo Update finished
goto END

:DIR
echo Default location of XPS MultiQuant is not found.
echo Copy files manually.

:NO
echo Batch terminated

:END
echo.
pause
