@echo off
rem Copyright M.Mohai 1999-2022

echo:
echo XPS MultiQuant Kratos Vision Converter
echo ________________________________________________________________
echo:
echo This command file will uninstall Kratos Vision Converter
echo from its default location 
echo:

rem Default folder of XPS MultiQuant 
set xmqdir=XMQ

ver | find "10.0" > nul
if not errorlevel 1 goto NT
ver | find "6.3" > nul
if not errorlevel 1 goto NT
ver | find "6.2" > nul
if not errorlevel 1 goto NT
ver | find "6.1" > nul
if not errorlevel 1 goto NT
ver | find "6.0" > nul
if not errorlevel 1 goto NT
ver | find "5.2" > nul
if not errorlevel 1 goto NT
ver | find "XP" > nul
if not errorlevel 1 goto NT
ver | find "2000" > nul
if not errorlevel 1 goto NT
ver | find "NT" > nul
if not errorlevel 1 goto NT
ver | find "95" > nul
if not errorlevel 1 goto 9X
ver | find "98" > nul
if not errorlevel 1 goto 9X
ver | find "Millennium" > nul
if not errorlevel 1 goto 9X
echo Windows version could not be determined
goto MAN

:NT
set progdir=%ProgramFiles%
if exist "%ProgramFiles(x86)%" set progdir=%ProgramFiles(x86)%
title XPS MultiQuant Import
set /p answ=Do you want to continue [Y,N]? 
if /i '%answ%'=='Y' goto DLT
goto NO

:9X
set progdir=C:\Program Files
choice /c:YN Do you want to continue 
if errorlevel 2 goto NO

:DLT
if not exist "%progdir%\%xmqdir%\XMQ.exe" goto DIR
if exist "%progdir%\%xmqdir%\Import\VisionConvert.exe" del "%progdir%\%xmqdir%\Import\VisionConvert.exe"
if exist "%progdir%\%xmqdir%\Import\VisionConvert.chm" del "%progdir%\%xmqdir%\Import\VisionConvert.chm"
if exist "%ALLUSERSPROFILE%\Start Menu\Programs\XPS MultiQuant\Vision Converter.lnk" del "%ALLUSERSPROFILE%\Start Menu\Programs\XPS MultiQuant\Vision Converter.lnk"
if exist "%progdir%\%xmqdir%\Import" rmdir /s /q "%progdir%\%xmqdir%\Import"
echo Uninstall finished
goto END

:DIR
echo Default location of XPS MultiQuant is not found

:MAN
echo Delete files manually

:NO
echo Batch terminated

:END
echo:
pause
