@echo off
rem Copyright M.Mohai 1999-2022

echo:
echo XPS MultiQuant Kratos Vision Converter
echo ________________________________________________________________
echo:
echo This command file will install Kratos Vision Converter
echo to location of XPS MultiQuant
echo:
echo To copy the shortcut of the program's to the start menu,
echo you must have write permission for the 'All Users' folder.
echo:

rem Default folder of XPS MultiQuant 
set xmqdir=XMQ

ver | find "10.0" > nul
if not errorlevel 1 goto NT
ver | find "6.3" > nul
if not errorlevel 1 goto NT
ver | find "6.2" > nul
if not errorlevel 1 goto NT
ver | find "6.1" > nul
if not errorlevel 1 goto NT
ver | find "6.0" > nul
if not errorlevel 1 goto NT
ver | find "5.2" > nul
if not errorlevel 1 goto NT
ver | find "XP" > nul
if not errorlevel 1 goto NT
ver | find "2000" > nul
if not errorlevel 1 goto NT
ver | find "NT" > nul
if not errorlevel 1 goto NT
ver | find "95" > nul
if not errorlevel 1 goto 9X
ver | find "98" > nul
if not errorlevel 1 goto 9X
ver | find "Millennium" > nul
if not errorlevel 1 goto 9X
echo Windows version could not be determined
goto MAN

:NT
set progdir=%ProgramFiles%
if exist "%ProgramFiles(x86)%" set progdir=%ProgramFiles(x86)%
title XPS MultiQuant Import
set /p answ=Do you want to continue [Y,N]? 
if /i '%answ%'=='Y' goto CPY
goto NO

:9X
set progdir=C:\Program Files
choice /c:YN Do you want to continue 
if errorlevel 2 goto NO

:CPY
pushd %~dp0
if not exist "%progdir%\%xmqdir%\XMQ.exe" goto DIR
if not exist "%progdir%\%xmqdir%\Import" mkdir "%progdir%\%xmqdir%\Import"
copy /y VisionConvert.exe "%progdir%\%xmqdir%\Import"
copy /y VisionConvert.chm "%progdir%\%xmqdir%\Import"
copy /y UnInstall.bat "%progdir%\%xmqdir%\Import"
if "%progdir%"=="%ProgramFiles(x86)%" (
  copy /y "Vision Converter (x86).lnk" "%ALLUSERSPROFILE%\Start Menu\Programs\XPS MultiQuant\Vision Converter.lnk"
) else (
  copy /y "Vision Converter.lnk" "%ALLUSERSPROFILE%\Start Menu\Programs\XPS MultiQuant"
)
echo:
echo Check shortcut in Start menu and corrcet target, if necessary
echo (point to "%progdir%\%xmqdir%\Import\VisionConvert.exe")
echo:
echo Install finished
goto END

:DIR
echo Default location of XPS MultiQuant is not found

:MAN
echo Copy files manually

:NO
echo Batch terminated

:END
popd
echo:
pause
